/**
 * @file xt_sort.c
 *
 * @copyright Copyright  (C)  2016 Jörg Behrens <behrens@dkrz.de>
 *                                 Moritz Hanke <hanke@dkrz.de>
 *                                 Thomas Jahns <jahns@dkrz.de>
 *
 * @author Jörg Behrens <behrens@dkrz.de>
 *         Moritz Hanke <hanke@dkrz.de>
 *         Thomas Jahns <jahns@dkrz.de>
 */
/*
 * Keywords:
 * Maintainer: Jörg Behrens <behrens@dkrz.de>
 *             Moritz Hanke <hanke@dkrz.de>
 *             Thomas Jahns <jahns@dkrz.de>
 * URL: https://dkrz-sw.gitlab-pages.dkrz.de/yaxt/
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are  permitted provided that the following conditions are
 * met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *
 * Neither the name of the DKRZ GmbH nor the names of its contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
 * IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "xt/xt_sort.h"
#include "xt_sort_internal.h"

void (*xt_sort_int)(int *a, size_t n)
  = xt_mergesort_int;
void (*xt_sort_xt_int)(Xt_int *a, size_t n)
  = xt_mergesort_xt_int;
void (*xt_sort_index)(Xt_int *restrict a, int n, int *restrict idx,
                      int reset_index)
= xt_mergesort_index;
void (*xt_sort_idxpos)(idxpos_type *v, size_t n) = xt_mergesort_idxpos;
void (*xt_sort_xt_int_permutation)(Xt_int a[], size_t n, int permutation[])
= xt_mergesort_xt_int_permutation;
void (*xt_sort_int_permutation)(int a[], size_t n, int permutation[])
= xt_mergesort_int_permutation;

/*
 * void xt_sort_init(void) {
 *
 *   //! \todo getenv: key = XT_SORT_METHOD, possible values: { QUICKSORT, MERGESORT }; we might accept uppercase and lowercase values
 *
 *   /\* xt_sort_index  = ; *\/
 *   /\* xt_sort_idxpos = ; *\/
 * }
 */

void
xt_assign_id_map_int(size_t n, int *restrict a, int ofs)
{
  for(size_t i = 0; i < n; i++)
    a[i] = (int)i + ofs;
}



/*
 * Local Variables:
 * c-basic-offset: 2
 * coding: utf-8
 * indent-tabs-mode: nil
 * show-trailing-whitespace: t
 * require-trailing-newline: t
 * End:
 */
